% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_health_facilities.R
\name{read_health_facilities}
\alias{read_health_facilities}
\title{Download geolocated data of health facilities}
\usage{
read_health_facilities(date = 202303, showProgress = TRUE, cache = TRUE)
}
\arguments{
\item{date}{Numeric. Date of the data in YYYYMM format. Defaults to \code{202303},
which was the latest data available by the time of this update.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}

\item{cache}{Logical. Whether the function should read the data cached
locally, which is faster. Defaults to \code{cache = TRUE}. By default,
\code{geobr} stores data files in a temporary directory that exists only
within each R session. If \code{cache = FALSE}, the function will download
the data again and overwrite the local file.}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
Data comes from the National Registry of Healthcare facilities (Cadastro
Nacional de Estabelecimentos de Saude - CNES), originally collected by the
Brazilian Ministry of Health. According to the Ministry of Health: "The
coordinates of each facility were obtained by CNES and validated by means of
space operations. These operations verify if the point is in the municipality,
considering a radius of 5,000 meters. When the coordinate is not correct,
further searches are done in other systems of the Ministry of Health and in
web services like Google Maps. Finally, if the coordinates have been correctly
obtained in this process, the coordinates of the municipal head office are
used. The geocode source used is registered in the database in a specific
column \code{data_source}. Periodically the coordinates are revised with the
objective of improving the quality of the data." The date of the last data
update is registered in the database in the columns \code{date_update} and
\code{year_update}. More information in the CNES data set available at \url{https://dados.gov.br/}.
These data use Geodetic reference system "SIRGAS2000" and CRS(4674).
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read all health facilities of the whole country
h <- read_health_facilities( date = 202303)
\dontshow{\}) # examplesIf}
}
\seealso{
Other area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_capitals}()},
\code{\link{read_comparable_areas}()},
\code{\link{read_country}()},
\code{\link{read_disaster_risk_area}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_indigenous_land}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_metro_area}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipal_seat}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_pop_arrangements}()},
\code{\link{read_region}()},
\code{\link{read_schools}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_urban_area}()},
\code{\link{read_urban_concentrations}()},
\code{\link{read_weighting_area}()}
}
\concept{area functions}
