% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_distexp.R
\name{get_distexp}
\alias{get_distexp}
\title{Get the expectation of treatment events with arbitrary distances}
\usage{
get_distexp(
  cf_sim_results,
  entire_window,
  dist_map,
  dist_map_unit = "km",
  use_raw = FALSE
)
}
\arguments{
\item{cf_sim_results}{output of `sim_cf_dens()`}

\item{entire_window}{owin object of the entire region}

\item{dist_map}{im object whose cell values are the distance from a focus (e.g., city)}

\item{dist_map_unit}{either `"km"` or `"mile"`}

\item{use_raw}{logical. `use_raw` specifies whether to use the raw value of expectations or percentiles.
By default, `FALSE`.}
}
\value{
A list of resulting dataframe (`result_data`), windows (`window_list`), data for distance quantiles,
and a window object for the entire window
}
\description{
`get_distexp()` takes counterfactual densities and
and returns the expected number of treatment events based on distances
from a user-specified focus.
}
