% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourier.R
\name{srw}
\alias{srw}
\title{Radial Wavelength Metrics}
\usage{
srw(x, create_plot = FALSE, option = c(1, 2, 3))
}
\arguments{
\item{x}{A raster or matrix.}

\item{create_plot}{Logical. If \code{TRUE}, returns a plot of the
amplitude spectrum with lines showing the radii at which
Srw, Srwi, and Shw are calculated.}

\item{option}{Numeric. Code for which output metric(s) to return. 1 = Srw, 2 = Srwi, 3 = Shw.}
}
\value{
A vector containing numeric values for the dominant
  radial wavelength, radial wavelength index, and mean half
  wavelength.
}
\description{
Calculates the dominant radial wavelength, radial wavelength
index, and mean half wavelength of the radial Fourier spectrum.
See Kedron et al. (2018) for more detailed description.
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# calculate metrics
srwvals <- srw(normforest)

# extract each value
Srw <- srwvals[1]
Srwi <- srwvals[2]
Shw <- srwvals[3]
}
