% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogc_api_nls.R
\name{ogc_get_maastotietokanta}
\alias{ogc_get_maastotietokanta}
\title{Download a Collection from the Maastotietokanta (Topographic Database)}
\usage{
ogc_get_maastotietokanta(
  collection = "hautausmaa",
  crs = 3067,
  limit = NULL,
  max_pages = 100,
  bbox = NULL,
  api_key = getOption("geofi_mml_api_key")
)
}
\arguments{
\item{collection}{Character. The name of the collection to download (e.g.,
\code{"hautausmaa"} for cemeteries). Use
\code{\link{ogc_get_maastotietokanta_collections}} to see available
collections.}

\item{crs}{Numeric or Character. The coordinate reference system (CRS)
for the output data, specified as an EPSG code. Supported values are
\code{3067} (ETRS-TM35FIN, default) and \code{4326} (WGS84). The returned
\code{sf} object will be transformed to this CRS.}

\item{limit}{Numeric or NULL. The maximum number of features to retrieve in
a single API request. If \code{NULL} (default), all available features are
fetched, potentially using pagination for large collections.}

\item{max_pages}{Numeric. The maximum number of pages to fetch during pagination
when \code{limit=NULL}. Defaults to 100. Increase this value for very large
collections (e.g., \code{"suo"}), but be cautious of long runtimes.}

\item{bbox}{Character or NULL. A bounding box to filter the data, specified as
a string in the format \code{"minx,miny,maxx,maxy"} (e.g.,
\code{"24.5,60.1,25.5,60.5"}). Coordinates must be in the same CRS as the
API (EPSG:4326). If \code{NULL} (default), no spatial filter is applied.}

\item{api_key}{Character. API key for authenticating with the Maastotietokanta
OGC API. Defaults to the value stored in
\code{options(geofi_mml_api_key)}. You can obtain an API key from the
National Land Survey of Finland website (see
\url{https://www.maanmittauslaitos.fi/en/rajapinnat/api-avaimen-ohje}).}
}
\value{
An \code{sf} object containing the spatial features from the specified
collection, transformed to the requested \code{crs}.
}
\description{
Downloads a specific collection of spatial data from the Maastotietokanta
(Topographic Database) using the OGC API provided by the National Land Survey
of Finland (NLS).
}
\details{
This function retrieves spatial data from the Maastotietokanta (Topographic
Database) OGC API, provided by the National Land Survey of Finland (NLS). It
acts as a wrapper around a lower-level API request function, adding user-friendly
features like CRS transformation and spatial filtering.

Key features:
\itemize{
\item Supports pagination for large collections when \code{limit=NULL}.
\item Limits the number of pages fetched during pagination using \code{max_pages}.
\item Applies spatial filtering using a bounding box (\code{bbox}).
\item Transforms the output to the specified CRS (\code{crs}).
\item Validates inputs to prevent common errors.
}

To see the list of available collections, use
\code{\link{ogc_get_maastotietokanta_collections}}.

For very large collections (e.g., \code{"suo"}), the function may fetch data in
pages of 10,000 features each. If the number of pages exceeds \code{max_pages},
a warning is issued, and only the features from the first \code{max_pages} pages
are returned. Increase \code{max_pages} to retrieve more features, but be aware
that this may significantly increase runtime.
}
\examples{
\dontrun{
# Set your API key
options(geofi_mml_api_key = "your_api_key_here")

# Download the "hautausmaa" (cemeteries) collection in EPSG:3067
cemeteries <- ogc_get_maastotietokanta(collection = "hautausmaa")
print(cemeteries)

# Download the "suo" (bogs/marshes) collection with a higher page limit
bogs <- ogc_get_maastotietokanta(
  collection = "suo",
  max_pages = 500
)
print(bogs)

# Download with a bounding box (in EPSG:4326) and transform to EPSG:4326
cemeteries_bbox <- ogc_get_maastotietokanta(
  collection = "hautausmaa",
  bbox = "24.5,60.1,25.5,60.5",
  crs = 4326
)
print(cemeteries_bbox)

}

}
\seealso{
\code{\link{ogc_get_maastotietokanta_collections}} to list available collections.
\url{https://www.maanmittauslaitos.fi/en/maps-and-spatial-data/datasets-and-interfaces/product-descriptions/topographic-database}
for more information on the Maastotietokanta.
\url{https://www.maanmittauslaitos.fi/en/rajapinnat/api-avaimen-ohje} for
instructions on obtaining an API key.
}
\author{
Markus Kainu \email{markus.kainu@kapsi.fi}
}
