% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_prediction.R
\name{create_tte_prior}
\alias{create_tte_prior}
\title{Create an arbitrary prior data set from a specified Curve object}
\usage{
create_tte_prior(
  curve,
  duration,
  events,
  Time = "Time",
  Event = "Event",
  censoringOne = FALSE
)
}
\arguments{
\item{curve}{Curve object with the desired prior distribution}

\item{duration}{The positive number for the time over which events should occur. This controls data maturity.
When used as a prior, the longer the time, the more information is provided.}

\item{events}{The positive integer for the number of events that should occur. The more events, the more information contained when used as a prior.}

\item{Time}{The output column name for the times. Default is "Time"}

\item{Event}{The output column name for the events column (i.e. the binary variable denoting events vs censorings). Default is "Event"}

\item{censoringOne}{Specify whether output censoring is denoted in the Event column by a one (TRUE) or zero (FALSE). Default=FALSE (censorings denoted by 0, events by 1)}
}
\value{
A two-column data frame containing times in the first column and an event/censoring indicator in the second.
}
\description{
This is a function to create a patient-level prior data set from a specified Curve.\cr
It can be used to create a prior data set where only summary parameters are known.
It requires a 'curve' object containing the desired distribution, the 'time' over which events occur and the number of 'events'.
Designed to be used in conjunction with event prediction methods.
Note that the output can be 'too perfect', so that when the output is used for curve-fitting it may result in over-precision.
To minimise this effect, it may better to derive the prior data set using a different distribution to the one later used for fitting or specifying down-weighting.
}
\examples{
example_prior <- create_tte_prior(curve=Weibull(100,0.8),duration=20,events=50)
}
\author{
James Bell
}
