% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{renderTable}
\alias{renderTable}
\title{Render HTML Table in R Markdown with Data from Web}
\usage{
renderTable(url = "./data/df.csv", isjson = FALSE)
}
\arguments{
\item{url}{A string. The URL to the source data of the table to be
created. Could be a relative path (relative to the \code{.Rmd} src
file) or an URL to a JSON or CSV file. \code{url} could also be an URL
to a publicly viewable Google Spreadsheet. Defaults to \code{./data/df.csv}
(see the template's structure).}

\item{isjson}{Boolean. Whether the format of the self-hosted file is
json. Defaults to \code{FALSE}. Works only when the data is self-hosted
(i.e. not from Google Spreadsheet).}
}
\value{
A string representing an HTML div tag.
}
\description{
This function is expected to work with \code{getable}'s R Markdown
template, which contains an \code{.html} file, a \code{.js} file,
and a \code{.css} file in addition to the \code{.Rmd} source file.
The function creates an HTML string and insert it into the HTML file
rendered from Rmd. The code in the \code{.js} file then process the
HTML string and retrieve data from web to create an HTML table dynamically
when users view the rendered HTML file in the browser (a server is needed to
served the file).
}
\examples{
renderTable("https://raw.githubusercontent.com/liao961120/getable/master/docs/demo/data/df.csv")
}
