% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/half_normal.R
\name{half_normal}
\alias{half_normal}
\title{Half-Normal Effects Plots}
\usage{
half_normal(
  model,
  method = "Lenth",
  alpha = 0.05,
  label_active = FALSE,
  ref_line = FALSE,
  margin_errors = FALSE,
  point_color = "#21908CFF",
  showplot = TRUE
)
}
\arguments{
\item{model}{object of class "lm"}

\item{method}{Character value. Method to calculate PSE. Default is Lenth. Options include: Zahn, WZahn, Lenth, RMS, Dong, JuanPena, Daniel. See Details.}

\item{alpha}{specify the significance level to compute margin of errors. Numeric significance level, between 0 and 1. Default is alpha=0.05}

\item{label_active}{If TRUE, active effects are labeled if the effects cross the computed margin of error (ME). See method argument for more details}

\item{ref_line}{Dafault is TRUE, if FALSE the abline with slope (1/PSE) is not displayed. Reference line should follow along most points that are not considered outliers.}

\item{margin_errors}{Default is FALSE, if TRUE the cutoffs for margin of errors (ME) and simultaneous margin of error (SME) are shown}

\item{point_color}{Change color of points in plot}

\item{showplot}{Default is TRUE, if FALSE plot will not be shown and a tibble is returned used to create the plot along with the calculated PSE,ME,SME}
}
\value{
A tibble with the absolute effects and half-normal quantiles. A ggplot2 version of halfnormal plot for factorial effects is returned
}
\description{
Half-Normal Effects Plots
}
\details{
The method argument is a simple wrapper for the function PSE() from the unrepx R package.
For more details you can use ?unrepx::PSE(). The \emph{method} arguement implements methods of estimating the standard error of
effects estimates from unreplicatd designs. The methods include
\describe{
\item{Daniel: }{The 68.3rd quantile of the absolute effects. See Daniel (1959) }
\item{Dong: }{The RMS method, applied after excluding all
effects that exceed 2.5 * PSE(effects, "SMedian") in absolute value. See Dong (1993)}
\item{JuanPena: }{An iterated median method whereby we repeatedly calculate the
median of the absolute effects that don't exceed 3.5 times the previous median, until it stabilizes.
The estimate is the final median, divided by .6578. See Juan and Pena (1992).}
\item{Lenth (Default): }{The SMedian method, applied after excluding all effects that exceed 2.5 * PSE(effects, "SMedian")
in absolute value. See Lenth (1989)}
\item{RMS: }{Square root of the mean of the squared effects. This is not a good PSE in the presence of active effects,
but it is provided for sake of comparisons}
\item{SMedian: }{1.5 times the median of the absolute effects}
\item{Zahn, WZahn: }{The Zahn method is the slope of the least-squares line fitted to the first m points of unrepx::hnplot(effects, horiz = FALSE),
where m = floor(.683 * length(effects)). (This line is fitted through the origin.)
The WZahn method is an experimental version of Zahn's method,
based on weighted least-squares
with weights decreasing linearly from m - .5 to .5, but bounded above by .65m}

}
}
\examples{
model <- lm(ybar ~ (A+B+C+D)^4,data=adapted_epitaxial)
half_normal(model)
half_normal(model,method='Zahn',alpha=0.1,ref_line=TRUE,
            label_active=TRUE,margin_errors=TRUE)
}
\references{
Daniel, C (1959) Use of Half-Normal Plots in Interpreting Factorial Two-Level Experiments. Technometrics, 1(4), 311-341 \cr \cr
Dong, F (1993) On the Identification of Active Contrasts in Unreplicated Fractional Factorials. Statistica Sinica 3, 209-217 \cr \cr
Hamada and Balakrishnan (1998) Analyzing Unreplicated Factorial Experiments: A Review With Some New Proposals. Statistica Sinica 8, 1-41 \cr \cr
Juan, J and Pena, D (1992) A Simple Method to Identify Significant Effects in Unreplicated Two-Level Factorial Designs. Communications in Statistics: Theory and Methods 21, 1383-1403 \cr \cr
Lenth, R (1989) Quick and Easy Analysis of Unrelicated Factorials Technometrics 31(4), 469-473 \cr \cr
Zahn, D (1975) Modifications of and Revised Critical Values for the Half-Normal Plot. Technometrics 17(2), 189-200
}
