% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_every_nth.R
\name{label_every_nth}
\alias{label_every_nth}
\title{Label every nth element}
\usage{
label_every_nth(n = 2, offset = 0, ...)
}
\arguments{
\item{n}{The increment of elements to hold as is. Defaults to \code{2}.}

\item{offset}{An offset for which element to first hold. Defaults to \code{0}. Possible values are \code{-1} to (\code{n - 2})}

\item{...}{If numeric, arguments passed to the \code{scales::comma} function. Otherwise, arguments passed to \code{format}.}
}
\value{
A labelling function
}
\description{
Label every nth element in a vector, and replace the rest with "".
}
\examples{
 label_every_nth()(scales::comma(seq(1000, 5000, 1000)))
 label_every_nth()(lubridate::ymd(c("2021-01-01", "2022-01-01", "2023-01-01", "2024-01-01")))
 label_every_nth()(LETTERS[1:12])

 library(dplyr)
 library(palmerpenguins)

 set_blanket()

 penguins |>
   mutate(across(sex, \(x) stringr::str_to_sentence(x))) |>
   gg_point(
     x = flipper_length_mm,
     y = body_mass_g,
     col = sex,
     x_labels = label_every_nth(),
     y_labels = label_every_nth(),
   )
}
