% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_pt.R
\name{gg_pt}
\alias{gg_pt}
\title{Plots for power transformations}
\usage{
gg_pt(
  df,
  vble,
  group = NULL,
  taus = c(-1, -0.5, -0.25, 0, 0.25, 0.5, 1),
  xlabel = "Normal quantiles",
  ylabel = paste("Transformed", quo_text(vble)),
  nrow = 2,
  ...
)
}
\arguments{
\item{df}{dataframe}

\item{vble}{numeric variable in df to be transformed}

\item{group}{optional character or factor grouping variable in df. Defaults
to NULL.}

\item{taus}{vector of numeric values for the power transformations (0 is
considered to be the log transform)}

\item{xlabel}{x-axis label}

\item{ylabel}{y-axis label}

\item{nrow}{number of rows for facet_wrap, only applied when group is NULL.}

\item{...}{parameters to be passed to stat_qq(), such as size, color, shape.}
}
\value{
a ggplot
}
\description{
Returns normal QQ plots for a set of power transformations. If there are
groups in the data, transformations can be applied separately to each of
them.
}
\examples{
library(dplyr)

# Without groups
fusion \%>\%
  filter(nv.vv == "VV") \%>\%
  gg_pt(time)

fusion \%>\%
  filter(nv.vv == "VV") \%>\%
  gg_pt(time, taus = c(-0.25, -0.5, -1, 0),
        xlabel = "Cuantiles normales", ylabel = "Valores transformados",
        nrow = 3, color = "red")

# With groups
gg_pt(fusion, time, nv.vv, taus = c(-0.5, -0.25, 0, 0.25, 0.5))

}
