% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_sl.R
\name{gg_sl}
\alias{gg_sl}
\title{Spread-Location plot}
\usage{
gg_sl(
  df,
  vble,
  group,
  jitterwidth = 0.1,
  jitteralpha = 0.5,
  linecol = "red",
  ylabel = expression(sqrt(abs(" Residuals "))),
  xlabel = "Medians"
)
}
\arguments{
\item{df}{dataframe}

\item{vble}{numeric variable to be analized}

\item{group}{grouping character or factor variable}

\item{jitterwidth}{width argument for geom_jitter}

\item{jitteralpha}{alpha argument for geom_jitter}

\item{linecol}{col argument for geom_line}

\item{ylabel}{y-axis label}

\item{xlabel}{x-axis label}
}
\value{
a ggplot object with the spread-location plot
}
\description{
Returns a spread-location plot.
}
\examples{
library(ggplot2)

gg_sl(fusion, time, nv.vv)

gg_sl(fusion, time, nv.vv, jitterwidth = 0.4, linecol = "blue",
      jitteralpha = 1) +
  scale_color_discrete("Grupo") +
  xlim(2, 8)

}
