% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_coplot.R
\name{make_coplot_df}
\alias{make_coplot_df}
\title{Creation of tibbles por coplots}
\usage{
make_coplot_df(df, vble, number_bins = 6, overlap = 0.5, equal_length = TRUE)
}
\arguments{
\item{df}{dataframe}

\item{vble}{faceting numeric variable}

\item{number_bins}{integer; the number of conditioning intervals}

\item{overlap}{numeric < 1; the fraction of overlap of the conditioning variables}

\item{equal_length}{if `overlap = 0` non overlaping intervals are produced
all with same length if `equal_length` is `TRUE` (default) or with the same
number of values otherwise.}
}
\value{
a dataset to be used in the creation of coplots
}
\description{
It creates dataframes to be used in coplot
}
\details{
Adapted from \href{https://jfukuyama.github.io/teaching/stat670/notes/lecture-11.html}{here}.

If `overlap = 0` then `ggplot2::cut_interval` is used to generate
  the intervals if `equal_length = TRUE` (default), otherwise
  `ggplot2::cut_number` is used. If `overlap` is not zero,
  `graphics::co.interval` is called.
}
\examples{
data_coplot <- make_coplot_df(rubber, hardness, 6, 3/4)
}
