% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equivalence.R
\name{Equivalent DAGs and Classes}
\alias{Equivalent DAGs and Classes}
\alias{node_equivalent_dags}
\alias{ggdag_equivalent_dags}
\alias{node_equivalent_class}
\alias{ggdag_equivalent_class}
\title{Generating Equivalent Models}
\usage{
node_equivalent_dags(.dag, n = 100, layout = "auto", ...)

ggdag_equivalent_dags(
  .tdy_dag,
  ...,
  node_size = 16,
  text_size = 3.88,
  label_size = text_size,
  text_col = "white",
  label_col = "black",
  node = TRUE,
  stylized = FALSE,
  text = TRUE,
  use_labels = NULL
)

node_equivalent_class(.dag, layout = "auto")

ggdag_equivalent_class(
  .tdy_dag,
  expand_x = expansion(c(0.1, 0.1)),
  expand_y = expansion(c(0.1, 0.1)),
  breaks = ggplot2::waiver(),
  ...,
  node_size = 16,
  text_size = 3.88,
  label_size = text_size,
  text_col = "white",
  label_col = text_col,
  node = TRUE,
  stylized = FALSE,
  text = TRUE,
  use_labels = NULL
)
}
\arguments{
\item{.dag}{input graph, an object of class \code{tidy_dagitty} or \code{dagitty}}

\item{n}{maximal number of returned graphs.}

\item{layout}{a layout available in \code{ggraph}. See \code{\link[ggraph:ggraph]{ggraph::create_layout()}}
for details. Alternatively, \code{"time_ordered"} will use
\code{time_ordered_coords()} to algorithmically sort the graph by time.}

\item{...}{optional arguments passed to \code{ggraph::create_layout()}}

\item{.tdy_dag}{an object of class \code{tidy_dagitty} or \code{dagitty}}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{color of label text}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for \code{geom_dag_label_repel()}.
Default is \code{NULL}.}

\item{expand_x, expand_y}{Vector of range expansion constants used to add some
padding around the data, to ensure that they are placed some distance away
from the axes. Use the convenience function \code{ggplot2::expansion()} to
generate the values for the expand argument.}

\item{breaks}{One of:
\itemize{
\item NULL for no breaks
\item waiver() for the default breaks computed by the transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks as output
}}
}
\value{
a \code{tidy_dagitty} with at least one DAG, including a \code{dag}
column to identify graph set for equivalent DAGs or a \code{reversable}
column for equivalent classes, or a \code{ggplot}
}
\description{
Returns a set of complete partially directed acyclic graphs (CPDAGs) given an
input DAG. CPDAGs are Markov equivalent to the input graph. See
\code{\link[dagitty:EquivalentModels]{dagitty::equivalentDAGs()}} for details.
\code{node_equivalent_dags()} returns a set of DAGs, while
\code{node_equivalent_class()} tags reversable edges.
\code{ggdag_equivalent_dags()} plots all equivalent DAGs, while
\code{ggdag_equivalent_class()} plots all reversable edges as undirected.
}
\examples{
g_ex <- dagify(y ~ x + z, x ~ z)

g_ex \%>\% node_equivalent_class()

g_ex \%>\% ggdag_equivalent_dags()

}
