% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{Pathways}
\alias{Pathways}
\alias{dag_paths}
\alias{ggdag_paths}
\alias{ggdag_paths_fan}
\title{Find Open Paths Between Variables}
\usage{
dag_paths(
  .dag,
  from = NULL,
  to = NULL,
  adjust_for = NULL,
  limit = 100,
  directed = FALSE,
  paths_only = FALSE,
  ...
)

ggdag_paths(
  .tdy_dag,
  from = NULL,
  to = NULL,
  adjust_for = NULL,
  limit = 100,
  directed = FALSE,
  shadow = FALSE,
  ...,
  node_size = 16,
  text_size = 3.88,
  label_size = text_size,
  text_col = "white",
  label_col = text_col,
  node = TRUE,
  stylized = FALSE,
  text = TRUE,
  use_labels = NULL
)

ggdag_paths_fan(
  .tdy_dag,
  from = NULL,
  to = NULL,
  adjust_for = NULL,
  limit = 100,
  directed = FALSE,
  ...,
  shadow = FALSE,
  spread = 0.7,
  node_size = 16,
  text_size = 3.88,
  label_size = text_size,
  text_col = "white",
  label_col = text_col,
  node = TRUE,
  stylized = FALSE,
  text = TRUE,
  use_labels = NULL
)
}
\arguments{
\item{.dag, .tdy_dag}{input graph, an object of class \code{tidy_dagitty} or
\code{dagitty}}

\item{from}{character vector of length 1, name of exposure variable. Default
is \code{NULL}, in which case it will check the input DAG for exposure.}

\item{to}{character vector of length 1, name of exposure variable. Default is
\code{NULL}, in which case it will check the input DAG for exposure.}

\item{adjust_for}{character vector, a set of variables to control for.
Default is \code{NULL}.}

\item{limit}{maximum amount of paths to show. In general, the number of paths grows
exponentially with the number of variables in the graph, such that path inspection
is not useful except for the most simple models.}

\item{directed}{logical. Should only directed paths be shown?}

\item{paths_only}{logical. Should only open paths be returned? Default is
\code{FALSE}, which includes every variable and edge in the DAG regardless
if they are part of the path.}

\item{...}{additional arguments passed to \code{tidy_dagitty()}}

\item{shadow}{logical. Show edges which are not on an open path? Ignored if
\code{paths_only} is \code{TRUE}.}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{label color}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for \code{geom_dag_label_repel()}.
Default is \code{NULL}.}

\item{spread}{the width of the fan spread}
}
\value{
a \code{tidy_dagitty} with a \code{path} column for path variables and a \code{set}
grouping column or a \code{ggplot}.
}
\description{
\code{dag_paths} finds open paths between a given exposure and outcome.
\code{ggdag_paths} and \code{ggdag_paths_fan} plot all open paths. See
\code{\link[dagitty:paths]{dagitty::paths()}} for details.
}
\examples{
confounder_triangle(x_y_associated = TRUE) \%>\%
  dag_paths(from = "x", to = "y")

confounder_triangle(x_y_associated = TRUE) \%>\%
  ggdag_paths(from = "x", to = "y")

butterfly_bias(x_y_associated = TRUE) \%>\%
  ggdag_paths_fan(shadow = TRUE)

}
