% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{getAncestors}
\alias{getAncestors}
\title{Returns a list of the ancestors of a particular variety (if they exist)}
\usage{
getAncestors(v1, geneal, gen = 3)
}
\arguments{
\item{v1}{the label of the vertex of interest (in character string format)}

\item{geneal}{the full genealogy  (in data frame format)}

\item{gen}{the number of generations back to include as ancestors}
}
\description{
This function returns a list of the ancestors of the inputted variety within and including a given number of generations
}
\examples{
data(sbGeneal)
getParent("Essex", sbGeneal)
getAncestors("Essex", sbGeneal, 1)
getAncestors("Essex", sbGeneal, 5)
}
\references{
Rutter L, VanderPlas S, Cook D, Graham MA (2019).
ggenealogy: An R Package for Visualizing Genealogical Data.
\emph{Journal of Statistical Software},
\bold{89}(13), 1--31.
\doi{10.18637/jss.v089.i13}
}
