% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph.R
\name{gf_girafe}
\alias{gf_girafe}
\title{Render interactive ggformula plots}
\usage{
gf_girafe(ggobj, code, ...)
}
\arguments{
\item{ggobj}{A ggplot object, typically created with a \verb{gf_*_interactive()}
function.}

\item{code}{R code to execute. This parameter is optional and rarely used
in typical workflows.}

\item{...}{Additional arguments passed to \code{\link[ggiraph:girafe]{ggiraph::girafe()}}, such as
\code{width_svg}, \code{height_svg}, \code{options}, etc.}
}
\value{
An interactive HTML widget that can be displayed in RStudio Viewer,
R Markdown documents, or Shiny applications.
}
\description{
Converts a ggplot object with interactive elements into an interactive
HTML widget using ggiraph. This function is a wrapper around
\code{\link[ggiraph:girafe]{ggiraph::girafe()}} tailored for ggformula interactive plots.
}
\details{
This function takes a ggplot object containing interactive elements
(created with \verb{gf_*_interactive()} functions) and renders it as an
interactive plot. The resulting widget supports features like tooltips,
hover effects, and clickable elements.
}
\examples{
library(ggformula)

# Basic interactive plot
gf_point_interactive(mpg ~ wt, data = mtcars,
                    tooltip = ~ paste("Car:", rownames(mtcars))) |>
  gf_girafe()

# With custom sizing
gf_histogram_interactive(~ mpg, data = mtcars,
                        tooltip = ~ paste("Count:", after_stat(count))) |>
  gf_girafe(width_svg = 8, height_svg = 6)

}
\seealso{
\code{\link[ggiraph:girafe]{ggiraph::girafe()}}, \code{\link[=gf_point_interactive]{gf_point_interactive()}}, and other
\verb{gf_*_interactive()} functions
}
