% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moonGrob.R
\name{moonGrob}
\alias{moonGrob}
\alias{grid.moon}
\title{Draw a moon}
\usage{
moonGrob(
  x,
  y,
  ratio = 0.25,
  right = TRUE,
  r = 10,
  angle = 0,
  default.units = "npc",
  size.units = "mm",
  ...
)

grid.moon(..., draw = TRUE)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations.}

\item{y}{A numeric vector or unit object specifying y-locations.}

\item{ratio}{A numeric vector with values from 0 to 1 specifying the
proportion of the moons to draw.}

\item{right}{A boolean vector specifying whether the moon should be filled
from the right (TRUE) or left (FALSE).}

\item{r}{A numeric vector specifying the radii of the circles describing
the moons.}

\item{angle}{Not used.}

\item{default.units}{A string indicating the default units to use
    if \code{x}, \code{y}, \code{width}, or \code{height}
    are only given as numeric vectors.}

\item{size.units}{A string indicating the units to use for the radii of the
moons.}

\item{...}{Arguments passed on to \code{grid::polygonGrob}.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}
}
\value{
A grob object.
}
\description{
Functions to create and draw crescent or gibbous moon shapes.
}
\details{
Both functions create a moon grob (a graphical object describing a crescent
or gibbous moon), but only \code{grid.moon} draws the moon (and then only
if draw is TRUE).

These functions calculate a set of points describing the perimeters of the
moons and pass these points on to \code{grid::polygonGrob}.

The units in \code{default.units} and \code{size.units} can be different;
\code{grid} will add them together appropriately before drawing.
}
\examples{
grid::grid.newpage()
grid.moon(x = 1:3 * 0.25, y = rep(0.5, 3), ratio = 1:3 * 0.25, r = 10)
}
