% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_vanilla.R
\name{strip_vanilla}
\alias{strip_vanilla}
\title{Default strips}
\usage{
strip_vanilla(clip = "inherit", size = "constant")
}
\arguments{
\item{clip}{A \code{character(1)} that controls whether text labels are clipped to
the background boxes. Can be either \code{"inherit"} (default), \code{"on"} or
\code{"off"}.}

\item{size}{A \code{character(1)} stating that the strip margins in different
layers remain \code{"constant"} or are \code{"variable"}.}
}
\value{
A \code{Strip} ggproto object that can be used ggh4x facets.
}
\description{
Strips with the style of vanilla ggplot2.
}
\examples{
# Some dummy data with a long string
df <- data.frame(
  short = "X",
  long  = "A very long string that takes up a lot of space",
  value = 1
)
# Simple plot
p <- ggplot(df, aes(value, value)) +
  geom_point() +
  theme(strip.text.y.right = element_text(angle = 0))

# Short titles take up as much space as long titles
p + facet_grid2(
  vars(short, long),
  strip = strip_vanilla(size = "constant")
)

# Short titles take up less space
p + facet_grid2(
  vars(short, long),
  strip = strip_vanilla(size = "variable")
)
}
\seealso{
Other strips: 
\code{\link{strip_nested}()},
\code{\link{strip_split}()},
\code{\link{strip_tag}()},
\code{\link{strip_themed}()}
}
\concept{strips}
