% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonts.R
\name{validated_fonts}
\alias{validated_fonts}
\title{List of validated default fonts}
\usage{
validated_fonts(fonts = list())
}
\arguments{
\item{fonts}{Named list of font names to be aliased with
fonts installed on your system. If unspecified, the R default
families "sans", "serif", "mono" and "symbol"
are aliased to the family returned by \code{\link[=match_family]{match_family()}}.

If fonts are available, the default mapping will use these values:\tabular{llll}{
   R family \tab Font on Windows \tab Font on Unix \tab Font on Mac OS \cr
   \code{sans} \tab Arial \tab DejaVu Sans \tab Helvetica \cr
   \code{serif} \tab Times New Roman \tab DejaVu serif \tab Times \cr
   \code{mono} \tab Courier \tab DejaVu mono \tab Courier \cr
   \code{symbol} \tab Symbol \tab DejaVu Sans \tab Symbol \cr
}}
}
\value{
a named list of validated font family names
}
\description{
Validates and possibly modifies the fonts to be used as default
value in a graphic according to the fonts available on the machine. It process
elements named "sans", "serif", "mono" and "symbol".
}
\examples{
validated_fonts()
}
\seealso{
\code{\link[=girafe]{girafe()}}, \code{\link[=dsvg]{dsvg()}}

Other functions for font management: 
\code{\link{match_family}()}
}
\concept{functions for font management}
