% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_lgbtq}
\alias{theme_lgbtq}
\title{Use default theme for an LGBTQ palette}
\usage{
theme_lgbtq(name, ...)
}
\arguments{
\item{name}{\code{character(1)} \cr
Name of the flag the colors are based on.}

\item{...}{\code{ANY} \cr
Parameters passed to \code{\link[ggplot2:theme]{ggplot2::theme()}}.}
}
\value{
A ggplot2 \code{theme} object.
}
\description{
Provides a default theme for a given palette. Most LGBTQ flags
contain white, for which the default light gray background of ggplot2 is too
light. Conversely, this same gray is too dark for flags with yellow stripes.
LGBTQ themes are carefully curated for each palette.
}
\section{Available palettes}{

Currently available palettes are:
\itemize{
\item \code{rainbow} (6 colors)
\item \code{lesbian} (5 colors)
\item \code{gay} (5 colors)
\item \code{bisexual} (3 colors)
\item \code{transgender} (3 colors)
\item \code{asexual} (4 colors)
\item \code{intersex} (2 colors)
\item \code{nonbinary} (4 colors)
\item \code{philadelphia} (8 colors)
\item \code{progress} (11 colors)
\item \code{aromantic} (5 colors)
\item \code{acesthetic} (4 colors)
\item \code{analterous} (4 colors)
\item \code{asensual} (4 colors)
\item \code{ace_spectrum} (4 colors)
\item \code{aro_spectrum} (5 colors)
\item \code{aroace} (5 colors)
\item \code{alloace} (4 colors)
\item \code{aroallo} (5 colors)
\item \code{pansexual} (3 colors)
\item \code{androsexual} (3 colors)
\item \code{gynesexual} (3 colors)
\item \code{abrosexual} (5 colors)
\item \code{lesbian_7} (7 colors)
\item \code{gay_7} (7 colors)
\item \code{demiboy} (4 colors)
\item \code{demigirl} (4 colors)
\item \code{helian} (5 colors)
\item \code{lunarian} (5 colors)
\item \code{solarian} (5 colors)
\item \code{stellarian} (5 colors)
\item \code{genderfluid} (5 colors)
\item \code{genderqueer} (3 colors)
\item \code{agender} (4 colors)
\item \code{bigender} (6 colors)
\item \code{amatopunk} (5 colors)
\item \code{bear} (7 colors)
\item \code{butch} (7 colors)
\item \code{femme} (5 colors)
\item \code{otter} (5 colors)
\item \code{queerhet} (5 colors)
}
}

\examples{
data <- data.frame(
  x = 1:10, y = 15:6,
  group = rep(c("a", "b"), each = 5)
)

ggplot2::ggplot(data, ggplot2::aes(x = x, y = y, color = group)) +
  ggplot2::geom_point(size = 4) +
  scale_color_lgbtq("intersex") +
  # Use the same name as for values, preferably
  theme_lgbtq("intersex")

}
