% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gen_structured_model}
\alias{gen_structured_model}
\title{Simulation Scenario from Bhatnagar et al. (2018+) ggmix paper}
\usage{
gen_structured_model(
  n,
  p_design,
  p_kinship,
  k,
  s,
  Fst,
  b0,
  nPC = 10,
  eta,
  sigma2,
  geography = c("ind", "1d", "circ"),
  percent_causal,
  percent_overlap,
  train_tune_test = c(0.6, 0.2, 0.2)
)
}
\arguments{
\item{n}{number of observations to simulate}

\item{p_design}{number of variables in X_test, i.e., the design matrix}

\item{p_kinship}{number of variable in X_kinship, i.e., matrix used to
calculate kinship}

\item{k}{number of intermediate subpopulations.}

\item{s}{the desired bias coefficient, which specifies sigma indirectly.
Required if sigma is missing}

\item{Fst}{The desired final FST of the admixed individuals. Required if
sigma is missing}

\item{b0}{the true intercept parameter}

\item{nPC}{number of principal components to include in the design matrix
used for regression adjustment for population structure via principal
components. This matrix is used as the input in a standard lasso regression
routine, where there are no random effects.}

\item{eta}{the true eta parameter, which has to be \code{0 < eta < 1}}

\item{sigma2}{the true sigma2 parameter}

\item{geography}{the type of geography for simulation the kinship matrix.
"ind" is independent populations where every individuals is actually
unadmixed, "1d" is a 1D geography and "circ" is circular geography.
Default: "ind". See the functions in the \code{bnpsd} for details on how
this data is actually generated.}

\item{percent_causal}{percentage of \code{p_design} that is causal. must be
\eqn{0 \leq percent_causal \leq 1}. The true regression coefficients are
generated from a standard normal distribution.}

\item{percent_overlap}{this represents the percentage of causal SNPs that
will also be included in the calculation of the kinship matrix}

\item{train_tune_test}{the proportion of sample size used for training tuning
parameter selection and testing. default is 60/20/20 split}
}
\value{
A list with the following elements \describe{\item{ytrain}{simulated
  response vector for training set} \item{ytune}{simulated response vector
  for tuning parameter selection set} \item{ytest}{simulated response vector
  for test set} \item{xtrain}{simulated design matrix for training
  set}\item{xtune}{simulated design matrix for tuning parameter selection
  set}\item{xtest}{simulated design matrix for testing set}
  \item{xtrain_lasso}{simulated design matrix for training set for lasso
  model. This is the same as xtrain, but also includes the nPC principal
  components} \item{xtune_lasso}{simulated design matrix for tuning parameter
  selection set for lasso model. This is the same as xtune, but also includes
  the nPC principal components}\item{xtest}{simulated design matrix for
  testing set for lasso model. This is the same as xtest, but also includes
  the nPC principal components} \item{causal}{character vector of the names
  of the causal SNPs} \item{beta}{the vector of true regression coefficients}
  \item{kin_train}{2 times the estimated kinship for the training set
  individuals} \item{kin_tune_train}{The covariance matrix between the tuning
  set and the training set individuals} \item{kin_test_train}{The covariance
  matrix between the test set and training set individuals}
  \item{Xkinship}{the matrix of SNPs used to estimate the kinship matrix}
  \item{not_causal}{character vector of the non-causal SNPs} \item{PC}{the
  principal components for population structure adjustment} }
}
\description{
Function that generates data of the different simulation studies
  presented in the accompanying paper. This function requires the
  \code{popkin} and \code{bnpsd} package to be installed.
}
\details{
The kinship is estimated using the \code{popkin} function from the
  \code{popkin} package. This function will multiple that kinship matrix by 2
  to give the expected covariance matrix which is subsequently used in the
  linear mixed models
}
\examples{
admixed <- gen_structured_model(n = 100,
                                p_design = 50,
                                p_kinship = 5e2,
                                geography = "1d",
                                percent_causal = 0.10,
                                percent_overlap = "100",
                                k = 5, s = 0.5, Fst = 0.1,
                                b0 = 0, nPC = 10,
                                eta = 0.1, sigma2 = 1,
                                train_tune_test = c(0.8, 0.1, 0.1))
names(admixed)
}
\seealso{
\code{\link[bnpsd]{admix_prop_1d_linear}}
}
