% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{karim}
\alias{karim}
\title{Karim's Simulated Data}
\format{
A list with 6 elements: \describe{ \item{b}{vector of length 1000
  representing the true regression coefficients. 10 non-zero coefficients,
  the rest are 0.}\item{kin1}{the true kinship matrix}\item{s.g}{polygenic
  variance, set to be 1.26}\item{s.e}{error variance, set to be
  1}\item{h.tot}{the total trait heritability. Set to be 60%.}\item{G}{matrix
  of genotypes of dimension 600 x 1000 SNPs, with approximately 800 common
  and 200 rare SNPs}}
}
\usage{
karim
}
\description{
A simulated dataset with a kinship matrix
}
\details{
If you simulate data using the scenario provided in the example,
  then the QTL heritability of y will be 8% (i.e. the 10 SNPs will explain 8%
  of the trait’s total heritability), and the trait total heritability is set
  to be 60%
}
\examples{
data(karim)
# Simulate a response using the genotype matrix and the kinship matrix
Phi <- 2 * karim$kin1
intercept <- 1
P <- MASS::mvrnorm(1, rep(0,600), karim$s.g * Phi)
y <- intercept + karim$G \%*\% karim$b + P + rnorm(600,0,karim$s.e)
}
\keyword{datasets}
