% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_edge.r, R/stat_node.r
\docType{data}
\name{StatSankeyedge}
\alias{StatSankeyedge}
\alias{stat_sankeyedge}
\alias{StatSankeynode}
\alias{stat_sankeynode}
\title{Sankey stats}
\format{
An object of class \code{StatSankeyedge} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 4.

An object of class \code{StatSankeynode} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.
}
\usage{
StatSankeyedge

stat_sankeyedge(
  mapping = NULL,
  data = NULL,
  geom = "sankeyedge",
  position = "sankey",
  na.rm = FALSE,
  slope = 0.5,
  ncp = 100,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

StatSankeynode

stat_sankeynode(
  mapping = NULL,
  data = NULL,
  geom = "sankeynode",
  position = "sankey",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{a string naming the \code{ggplot2::proto} Geom subclass. Should be either
\code{"sankeynode"} or \code{"sankeedge"}.}

\item{position}{A \code{character} string or function specifying the positioning routine.
By default this is \code{"sankey"}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{slope}{Slope parameter (\code{numeric}) for the Bezier curves used to depict the edges.
Any value between 0 and 1 will work nicely. Other non-zero values will also work.}

\item{ncp}{Number of control points on the Bezier curve that forms the edge. Larger
numbers will result in smoother curves, but cost more computational time. Default is
100.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Passed to \code{\link[ggplot2:layer]{ggplot2::layer()}} function}
}
\value{
Returns a ggplot2 stat layer which can be used in a ggplot.
}
\description{
Aggregates value on the \code{y} axis per \code{group} for nodes, and for all used aesthetics for
edges.
}
\details{
Wrangles data before it can be passed to \code{\link[=position_sankey]{position_sankey()}}.
}
\examples{
library(ggplot2)
data("ecosystem_services")

p <- ggplot(ecosystem_services_pivot1, aes(x = stage, y = RCSES, group = node,
                                           connector = connector, edge_id = edge_id,
                                           fill = node))
p + stat_sankeynode()
p + stat_sankeyedge()
}
\author{
Pepijn de Vries
}
\keyword{datasets}
