% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/101_geomandstat.R
\name{geom_sii_riskconnection}
\alias{geom_sii_riskconnection}
\title{geom_sii_riskconnection}
\usage{
geom_sii_riskconnection(data = NULL, mapping = NULL,
  stat = "sii_riskconnection", position = "identity", na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{data}{the dataset in tidyverse format (column 'description' as a factor). see examples in \code{\link{sii_z_ex2_data}} or \code{\link{sii_z_ex3_data}}}

\item{mapping}{required aes(thetics) : 'x' (i.e. time, longitude, integer), 'y' (i.e SCR ratio, lattitude), 'id' and also 'comparewithid'}

\item{stat}{default stat is statsii_riskconnection, combinations with other stat's are not tested}

\item{position}{standard ggplot function}

\item{na.rm}{standard ggplot function}

\item{show.legend}{standard ggplot function}

\item{inherit.aes}{standard ggplot function}

\item{...}{ellipsis, a standard R parameter}
}
\value{
a 'ggplot2' object based on 'geom_polygon'
}
\description{
returns a 'ggplot2' object, based on geom_segment.; it plots a line between (x and y coordinates of) those datapoints which have a matching value in the columns 'id' and 'comparewithid'. values in 'id' must be unique. For values in 'comparewithid' is uniqueness not required, but a matching value in 'id' must be present.
}
\examples{
library(ggsolvencyii)
library(ggplot2)

sii_z_ex3_data[sii_z_ex3_data$description == "SCR", ]

ggplot() + geom_sii_riskconnection(data = sii_z_ex3_data, mapping = aes(
  comparewithid = comparewithid,
  x = time,
  y = ratio,
  id = id,
  ),
color = "red",
lwd = 0.7,
arrow = arrow()
)
}
