% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-raster-tern.R
\docType{data}
\name{annotation_raster_tern}
\alias{annotation_raster_tern}
\alias{GeomRasterAnnTern}
\title{Annotation: High-performance rectangular tiling (ggtern version)}
\usage{
annotation_raster_tern(
  raster,
  xmin = 0,
  xmax = 1,
  ymin = 0,
  ymax = 1,
  interpolate = FALSE
)
}
\arguments{
\item{raster}{raster object to display}

\item{xmin, xmax}{x location (in npc coordinates) giving horizontal
location of raster}

\item{ymin, ymax}{y location (in npc coordinates) giving vertical
location of raster}

\item{interpolate}{If \code{TRUE} interpolate linearly, if \code{FALSE}
(the default) don't interpolate.}
}
\description{
This is a special version of \code{\link[ggplot2]{geom_raster}} optimised for static
annotations that are the same in every panel. These annotations will not
affect scales (i.e. the x and y axes will not grow to cover the range
of the raster, and the raster must already have its own colours).
}
\details{
Most useful for adding bitmap images.
}
\examples{
data(Feldspar)
data(FeldsparRaster)
ggtern(Feldspar,aes(Ab,An,Or)) + 
theme_rgbw() + 
annotation_raster_tern(FeldsparRaster,xmin=0,xmax=1,ymin=0,ymax=1) +
geom_mask() + 
geom_point(size=5,aes(shape=Feldspar,fill=Feldspar),color='black') +
scale_shape_manual(values=c(21,24)) +
scale_fill_manual(values=c("red", "blue")) +
labs(title="Demonstration of Raster Annotation")
}
\author{
Nicholas Hamilton
}
\keyword{datasets}
