% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.nrm.R
\name{residuals.nrm}
\alias{residuals.nrm}
\title{Method to compute residuals of nrm models}
\usage{
\method{residuals}{nrm}(object, adj, RMSLE = FALSE, null = FALSE, ...)
}
\arguments{
\item{object}{nrm object}

\item{adj}{adjacency against which to compute residuals}

\item{RMSLE}{logical, return log residuals? default FALSE}

\item{null}{logical. use null model?}

\item{...}{additional parameters to be passed to and from internal functions.}
}
\value{
numeric vector, residuals of nrm model fit against the original data
}
\description{
Method to compute residuals of nrm models
}
\examples{

data('highschool.predictors')
highschool.m <- nrm(w=highschool.predictors[1], adj=contacts.adj, directed=FALSE, selfloops=FALSE)
residuals(highschool.m, contacts.adj)

}
