#' EST data -- Eastern Cooperative Oncology Group clinical trials, EST 2282
#'
#' @description The dataset est45 is from the Eastern Cooperative Oncology Group clinical trials, specifically EST 2282 (Falkson, Cnaan, and Simson, 1990) and EST 1286 (Falkson et al., 1995) containing 45 observations. The dataset consists of 191 observations. It includes several covariates: Fetoprtn (alpha fetoprotein), Antigen (antihepatitis B antigen), Jaundice (a biochemical marker; coded as 1 if present, 0 otherwise), and Age (age in years). The response variable Y represents the number of cancerous liver cells present at the start of the clinical trial.
#'
#' To assess the impact of these covariates on the likelihood of survival, a new variable called "survive" is created. "survive" is dichotomized based on Y: it is set to 1 if the number of cancerous liver cells is less than or equal to 8, and 0 otherwise.
#'
#' @format A data frame with 45 rows and 9 variables:
#' \describe{
#'   \item{Y}{Response variable}
#'   \item{Weeks}{Time in weeks}
#'   \item{Fetoprtn}{Alpha fetoprotein}
#'   \item{Antigen}{Anti-hepatitis B antigen}
#'   \item{Jaundice}{Jaundice indicator}
#'   \item{BMI}{Body mass index}
#'   \item{Age}{Age in years}
#'   \item{grp}{Group identifier}
#'   \item{resp}{Response variable dichotomized}
#' }
#' @source Generated for example purposes
#'
#' @references
#' Cytel Inc (2010). LogXact 9 User Manual: Discrete Regression Analysis. Cambridge, Massachusetts: Cytel Inc.
#'
#' Falkson, G., Lipsitz, S., Borden, E., Simson, I., W., and Haller, D. (1995). A ECOG randomized phase II study of beta interferon and Menogoril. American Journal of Clinical Oncology 18, 287–292.
#'
#' Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.
#'
#' Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
#'
#' @examples
#' data(est45)
#' f_fit <- emforbeta(resp ~ Fetoprtn + Antigen + Jaundice + Age,
#'                    data = est45, family = binomial, method = "glm.fit")
#' summary(f_fit$mfit)
#'
#' #Bias-reduced estimates due to Firth (1993)
#' f_fit <- emforbeta(resp ~ Fetoprtn + Antigen + Jaundice + Age,
#'                    data = est45, family = binomial, method = "brglmFit")
#' summary(f_fit$mfit)
"est45"



