#'@name ibrahim
#'@title  ibrahim data -- Ibrahim (1990) JASA
#'
#'@description The dataset ibrahim is from Ibrahim, IG (1990, 85, 765–769, JASA). The data contains a response variable y and predictors x1 x2 x3, and the total number of observations is 82.

#' @references
#' Cytel Inc (2010). LogXact 9 User Manual: Discrete Regression Analysis. Cambridge, Massachusetts: Cytel Inc.
#'
#' Ibrahim, J. G. (1990). Incomplete data in generalized linear models. Journal of the American Statistical Association 85, 765–769.
#'
#' Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.
#'
#' Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
#'
#' @examples
#'data(ibrahim)
#'f_fit <- emBinRegMAR(y ~ x1+x2+x3, data=ibrahim, family="binomial", biascorrectn=FALSE)
#' f_fit$beta
#' #Firth type bias correction
#' f_fit <- emBinRegMAR(y ~ x1+x2+x3, data=ibrahim, family="binomial", biascorrectn=TRUE)
#' f_fit$beta
#'
"ibrahim"

