% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{GUIDE}
\alias{GUIDE}
\title{Guidelines for Urinary Incontinence Discussion and Evaluation}
\format{
A data frame with 137 rows and 7 variables:
\describe{
  \item{bothered}{a numeric vector giving the answer to the following: Do you consider this accidental loss of urine a problem that interferes with your day to day activities or bothers you in other ways? 1 for "Yes" and 0 for "No".}
  \item{gender}{a factor giving the patient's gender: "Male" or "Female".}
  \item{age}{a numeric vector giving the standardized age: (age in years - 76)/10.}
  \item{dayacc}{a numeric vector giving the patient's report of the number of leaking accidents they experience in an average day (derived from number of accidents reported per week).}
  \item{severe}{a factor giving the severity of the loss of urine: "1" if there is only some moisture; "2" if the patient wet the underwear; "3" if the urine trickled down the thigh; and "4" if the patient wet the floor.}
  \item{toilet}{a numeric vector giving the patient's report on the number of times during the day he (or she) usually go to the toilet to urinate.}
  \item{practice}{a character string giving the identifier of the medical practice.}
}
}
\source{
\url{http://www.bios.unc.edu/~preisser/personal/uidata/preqaq99.dat}
}
\usage{
data(GUIDE)
}
\description{
These data arose from a randomized controlled trial that
assessed if provider adherence to a set of guidelines for treatment of
patients with urinary incontinence (UI) affected patient outcomes. Data
were collected on 137 elderly patients from 38 medical practices. The
number of patients per practice ranged from 1 to 8 and the median was
4 patients. The statistical analysis aims to determine what predicts
whether or not a patient considers their UI a problem that interferes
with him/her daily life.
}
\examples{
data(GUIDE)
mod <- bothered ~ gender + age + dayacc + severe + toilet
fit <- glmgee(mod, family=binomial(logit), id=practice, corstr="Exchangeable", data=GUIDE)
summary(fit)
}
\references{
Hammill B.G., Preisser J.S. (2006) A SAS/IML software program for GEE and regression diagnostics. \emph{Computational Statistics & Data Analysis} 51:1197-1212.

Jung K.-M. (2008) Local Influence in Generalized Estimating Equations. \emph{Scandinavian Journal of Statistics} 35:286-294.
}
\keyword{datasets}
