% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-link.R
\name{md_label}
\alias{md_label}
\title{Markdown link label}
\usage{
md_label(text, label, ..., .name = FALSE)
}
\arguments{
\item{text}{The text in the document to be hyperlinked.}

\item{label}{A link label that is referenced elsewhere in the document.}

\item{...}{A sequence of \code{label = "text"} named vector pairs. If any such
pairs are provided, \code{.name} will be considered \code{TRUE}.}

\item{.name}{logical; if \code{TRUE}, the pairs in \code{...} will be used instead of
any values supplied to \code{x} and \code{url}.}
}
\value{
A single \code{glue} vector of length equal to that of \code{label} and \code{url},
with elements the concatenated arguments.
}
\description{
Create the link labels that can latter be referred to with a link reference
from \code{\link[=md_reference]{md_reference()}}.
}
\details{
A link label begins with a left bracket and ends with the first right bracket
that is not backslash-escaped. Between these brackets there must be at least
one non-whitespace character.
}
\examples{
md_label(CRAN = "The CRAN website")
md_label(text = c("one", "two"), label = 1:2)
}
\seealso{
Other leaf block functions: 
\code{\link{md_blank}()},
\code{\link{md_chunk}()},
\code{\link{md_fence}()},
\code{\link{md_heading}()},
\code{\link{md_indent}()},
\code{\link{md_paragraph}()},
\code{\link{md_reference}()},
\code{\link{md_rule}()},
\code{\link{md_setext}()},
\code{\link{md_table}()}
}
\concept{leaf block functions}
