% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{gmfd_simulate}
\alias{gmfd_simulate}
\title{Simulation of a functional sample}
\usage{
gmfd_simulate(size, mean, covariance = NULL, rho = NULL, theta = NULL)
}
\arguments{
\item{size}{a positive integer indicating the size of the functional sample to simulate.}

\item{mean}{a vector representing the mean of the sample.}

\item{covariance}{a matrix from which the eigenvalues and eigenfunctions must be extracted.}

\item{rho}{a vector of the eigenvalues in descending order to be used for the simulation.}

\item{theta}{a matrix containing the eigenfunctions in its columns to be used for the simulation.}
}
\value{
The function returns a functional data object of type \code{funData}.
}
\description{
Simulate a univariate functional sample using a Karhunen Loeve expansion.
}
\examples{
# Define parameters
n <- 50
P <- 100
K <- 150

# Grid of the functional dataset
t <- seq( 0, 1, length.out = P )

# Define the means and the parameters to use in the simulation
# with the Karhunen - Loève expansion
m1 <- t^2 * ( 1 - t )

rho <- rep( 0, K )
theta <- matrix( 0, K, P )
for ( k in 1:K ) {
  rho[k] <- 1 / ( k + 1 )^2
  if ( k\%\%2 == 0 )
    theta[k, ] <- sqrt( 2 ) * sin( k * pi * t )
  else if ( k\%\%2 != 0 && k != 1 )
    theta[k, ] <- sqrt( 2 ) * cos( ( k - 1 ) * pi * t )
  else
    theta[k, ] <- rep( 1, P )
}

# Simulate the functional data
x <- gmfd_simulate( n, m1, rho = rho, theta = theta )
}
\keyword{Simulation}
