% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_config.R
\name{check_config}
\alias{check_config}
\title{Check config}
\usage{
check_config(
  icfg,
  reference_file = "config/default.cfg",
  modulepath = "modules/",
  settings_config = NULL,
  extras = NULL,
  saveCheck = FALSE
)
}
\arguments{
\item{icfg}{Input config which should be checked for consistency (either as
the config itself or as a file path linking to the config)}

\item{reference_file}{Reference config which is having the right format
(either as the config itself or as a file path linking to the config)}

\item{modulepath}{The path where the modules are stored. If set to NULL the
corresponding module check is deactivated.}

\item{settings_config}{path where the table of possible setting combinations
is stored, if NULL it is ignored}

\item{extras}{vector of setting names that are allowed to appear in the input config
even if they are missing in the reference config. That can be useful to allow for
additional settings/information which does not necessarily have to exist}

\item{saveCheck}{additional check which makes sure that saving and loading it to/from
YAML format does not change its contents}
}
\value{
The checked config as a config list ready for further usage.
}
\description{
Checks a model configuration file for consistency by comparing it to a
reference config file and the given module structure of the model. The
function will throw out an error if settings are missing in the config which
exist in the reference config, of if settings are set in the config which do
not exist in the reference config file or if a realization is chosen for a
module which does not exist, not allowed setting combinations.
}
\seealso{
\code{\link{getModules}}
}
\author{
Jan Philipp Dietrich, Lavinia Baumstark
}
