% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_summary_gmtfd.R
\name{summary.multifmanova}
\alias{summary.multifmanova}
\title{Print "multifmanova" object}
\usage{
\method{summary}{multifmanova}(object, ...)
}
\arguments{
\item{object}{a "multifmanova" object.}

\item{...}{integer indicating the number of decimal places to be used to present the numerical results.
It can be named \code{digits} as in the \code{round()} function (see examples).}
}
\value{
No return value, called for side effects.
}
\description{
Prints the summary of the global and multiple contrasts testing for functional data.
}
\details{
The function prints out the information about the number of functional variables, 
number of samples, number of observations in each sample, number of design time points, 
contrasts used, test statistics, critical values, \eqn{p}-values of tests performed by the
\code{gmtFD()} function. It also gives the decisions.
}
\examples{
# Some of the examples may run some time.

# Canadian weather data set
# There are three samples of mean temperature and precipitations for
# fifteen weather stations in Western Canada, another fifteen in Eastern Canada, 
# and the remaining five in Northern Canada.

# one functional variable - temperature
library(fda)
data_set_t <- t(CanadianWeather$dailyAv[,, "Temperature.C"])
# number of samples
k <- 3
# number of variables
p <- 1
# preparing data set
gr_label <- rep(c(1, 2, 3), c(15, 15, 5))
data_set <- list(list(data_set_t[gr_label == 1, ]),
                 list(data_set_t[gr_label == 2, ]),
                 list(data_set_t[gr_label == 3, ]))

# Tukey's contrast matrix
h_tukey <- GFDmcv::contr_mat(k, type = "Tukey")
h_tukey_m <- kronecker(h_tukey, diag(p))
# vector of blocks of contrasts labels
blocks_contrasts <- rep(1:(nrow(h_tukey_m) / p), each = p)
\donttest{
# testing without parallel computing
res <- gmtFD(data_set, h_tukey_m, blocks_contrasts)
summary(res, digits = 3)}
\dontshow{
data_set <- list(list(data_set_t[gr_label == 1, 1:5]),
                 list(data_set_t[gr_label == 2, 1:5]),
                 list(data_set_t[gr_label == 3, 1:5]))
# testing without parallel computing
res <- gmtFD(data_set, h_tukey_m, blocks_contrasts)
summary(res, digits = 3)}
# two functional variables - temperature and precipitation
library(fda)
data_set_t <- t(CanadianWeather$dailyAv[,, "Temperature.C"])
data_set_p <- t(CanadianWeather$dailyAv[,, "Precipitation.mm"])
# number of samples
k <- 3
# number of variables
p <- 2
# preparing data set
gr_label <- rep(c(1, 2, 3), c(15, 15, 5))
data_set <- list(list(data_set_t[gr_label == 1, ], data_set_p[gr_label == 1, ]),
                 list(data_set_t[gr_label == 2, ], data_set_p[gr_label == 2, ]),
                 list(data_set_t[gr_label == 3, ], data_set_p[gr_label == 3, ]))

# Tukey's contrast matrix
h_tukey <- GFDmcv::contr_mat(k, type = "Tukey")
h_tukey_m <- kronecker(h_tukey, diag(p))
# vector of blocks of contrasts labels
blocks_contrasts <- rep(1:(nrow(h_tukey_m) / p), each = p)
\donttest{
# testing without parallel computing
res <- gmtFD(data_set, h_tukey_m, blocks_contrasts)
summary(res, digits = 3)}

}
