% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hector.R
\name{estimate_hector}
\alias{estimate_hector}
\title{Estimate a stochastic model based on the MLE and the Hector implementation.}
\usage{
estimate_hector(
  x,
  n_seasonal = 1,
  model_string,
  likelihood_method = "AmmarGrag",
  cleanup = TRUE
)
}
\arguments{
\item{x}{A \code{gnssts} object}

\item{n_seasonal}{An \code{integer} specifying the number of seasonal component in the time series.}

\item{model_string}{A \code{string} specifying the model to be estimated.}

\item{likelihood_method}{A \code{string} taking either value "FullCov" or "AmmarGrag" that specify the method for the Likelihood computation.}

\item{cleanup}{A \code{boolean} specifying if the files created by the estimation procedure should be cleaned.}
}
\value{
A \code{gnsstsmodel} object.
}
\description{
Estimate a stochastic model based on the MLE and the Hector implementation.
}
\examples{
\dontrun{
cola = PBO_get_station(station_name = "COLA", column = "dE", time_range = c(51130, 52000))
fit_mle = estimate_hector(x = cola,
                          n_seasonal = 1, 
                          model_string = "wn+matern")

}

}
