% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oo.R
\name{new_goalp}
\alias{new_goalp}
\title{new_goalp: Creates a new goalp object}
\usage{
new_goalp(lp, A, m, b, w, p, varType, X, obj, eqs)
}
\arguments{
\item{lp}{lp object. The solution of the underlying linear program.}

\item{A}{Numeric matrix with goals coefficients. Only for original
variables. Rows and columns must be named.}

\item{m}{Character vector containg the relation between Ax and b. Each
element can be \code{=, ==, >, <. >=, <=}.}

\item{b}{Numeric vector with the right hand side of the goals.}

\item{w}{Numeric matrix (nC x 2) with the weights of each deviation.}

\item{p}{Numeric matrix containing the priorities of each deviation
variable for lexicographic goal programming. Lower numbers imply
higher priority.}

\item{varType}{Character vector describing the type of the original
variables, as either "b", "i", or "c".}

\item{X}{Numeric matrix with the value of the (decision) variables in
each iteration of the lexicographic optimisation.}

\item{obj}{Numeric vector with the value of the objective function in
each iteration of the lexicographic optimisation.}

\item{eqs}{Character vector with the human-readable formulation of the
problem. Generated automatically from A, b and w if not provided.}
}
\value{
A goalp object.
}
\description{
Constructor of goalp object
}
\details{
It doesn't do any checks, but it does generate objects
\itemize{
  \item \code{x}: Vector with the optimal value of decision variables.
  \item \code{d}: Matrix with the optimal value of the deviations.
  \item \code{solutionFound}: TRUE if a solution was found, FALSE otherwise.
}
}
