% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofar.R
\name{gofar_p}
\alias{gofar_p}
\title{Generalize Exclusive factor extraction via co-sparse unit-rank estimation (GOFAR(P)) using k-fold crossvalidation}
\usage{
gofar_p(
  Yt,
  X,
  nrank = 3,
  nlambda = 40,
  family,
  familygroup = NULL,
  cIndex = NULL,
  ofset = NULL,
  control = list(),
  nfold = 5,
  PATH = FALSE
)
}
\arguments{
\item{Yt}{response matrix}

\item{X}{covariate matrix; when X = NULL, the fucntion performs unsupervised learning}

\item{nrank}{an integer specifying the desired rank/number of factors}

\item{nlambda}{number of lambda values to be used along each path}

\item{family}{set of family gaussian, bernoulli, possion}

\item{familygroup}{index set of the type of multivariate outcomes: "1" for Gaussian, "2" for Bernoulli, "3" for Poisson outcomes}

\item{cIndex}{control index, specifying index of control variable in the design matrix X}

\item{ofset}{offset matrix specified}

\item{control}{a list of internal parameters controlling the model fitting}

\item{nfold}{number of fold for cross-validation}

\item{PATH}{TRUE/FALSE for generating solution path of sequential estimate after cross-validation step}
}
\value{
\item{C}{estimated coefficient matrix; based on GIC}
\item{Z}{estimated control variable coefficient matrix}
\item{Phi}{estimted dispersion parameters}
\item{U}{estimated U matrix (generalize latent factor weights)}
\item{D}{estimated singular values}
\item{V}{estimated V matrix (factor loadings)}
\item{lam}{selected lambda values based on the chosen information criterion}
\item{lampath}{sequences of lambda values used in model fitting. In each sequential unit-rank estimation step,
a sequence of length nlambda is first generated between (lamMax\emph{lamMaxFac, lamMax}lamMaxFac*lamMinFac) equally
spaced on the log scale, in which lamMax is estimated and the other parameters are specified in gofar_control.
The model fitting starts from the largest lambda and stops when the maximum proportion of nonzero elements is reached in
either u or v, as specified by spU and spV in gofar_control.}
\item{IC}{values of information criteria}
\item{Upath}{solution path of U}
\item{Dpath}{solution path of D}
\item{Vpath}{solution path of D}
\item{ObjDec}{boolian type matrix outcome showing if objective function is monotone decreasing or not.}
\item{familygroup}{spcified familygroup of outcome variables.}
}
\description{
Divide and conquer approach for low-rank and sparse coefficent matrix estimation: Exclusive extraction
}
\examples{

family <- list(gaussian(), binomial(), poisson())
control <- gofar_control()
nlam <- 40 # number of tuning parameter
SD <- 123

# Simulated data for testing

data('simulate_gofar')
attach(simulate_gofar)
q <- ncol(Y)
p <- ncol(X)
# Simulate data with 20\% missing entries
miss <- 0.20 # Proportion of entries missing
t.ind <- sample.int(n * q, size = miss * n * q)
y <- as.vector(Y)
y[t.ind] <- NA
Ym <- matrix(y, n, q)
naind <- (!is.na(Ym)) + 0 # matrix(1,n,q)
misind <- any(naind == 0) + 0
#
# Model fitting begins:
control$epsilon <- 1e-7
control$spU <- 50 / p
control$spV <- 25 / q
control$maxit <- 1000
# Model fitting: GOFAR(P) (full data)
set.seed(SD)
rank.est <- 5
\donttest{
fit.eea <- gofar_p(Y, X,
  nrank = rank.est, nlambda = nlam,
  family = family, familygroup = familygroup,
  control = control, nfold = 5
)

# Model fitting: GOFAR(P) (missing data)
set.seed(SD)
rank.est <- 5
fit.eea.m <- gofar_p(Ym, X,
  nrank = rank.est, nlambda = nlam,
  family = family, familygroup = familygroup,
  control = control, nfold = 5
)
}
}
\references{
\emph{ Mishra, Aditya, Dipak K. Dey, Yong Chen, and Kun Chen. Generalized co-sparse factor regression. Computational Statistics & Data Analysis 157 (2021): 107127}
}
