% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_auth.R
\name{drive_token}
\alias{drive_token}
\title{Produce configured token}
\usage{
drive_token()
}
\value{
A \code{request} object (an S3 class provided by \link[httr:httr-package]{httr}).
}
\description{
For internal use or for those programming around the Drive API.
Returns a token pre-processed with \code{\link[httr:config]{httr::config()}}. Most users
do not need to handle tokens "by hand" or, even if they need some
control, \code{\link[=drive_auth]{drive_auth()}} is what they need. If there is no current
token, \code{\link[=drive_auth]{drive_auth()}} is called to either load from cache or
initiate OAuth2.0 flow.
If auth has been deactivated via \code{\link[=drive_deauth]{drive_deauth()}}, \code{drive_token()}
returns \code{NULL}.
}
\examples{
\dontshow{if (drive_has_token()) withAutoprint(\{ # examplesIf}
req <- request_generate(
  "drive.files.get",
  list(fileId = "abc"),
  token = drive_token()
)
req
\dontshow{\}) # examplesIf}
}
\seealso{
Other low-level API functions: 
\code{\link{drive_has_token}()},
\code{\link{request_generate}()},
\code{\link{request_make}()}
}
\concept{low-level API functions}
