% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{neigh_index}
\alias{neigh_index}
\title{Previous, current, and next positions of a given index in a
cycle.}
\usage{
neigh_index(i, n)
}
\arguments{
\item{i}{Position in a cycle}

\item{n}{Length of the cycle}
}
\value{
A three component vector c(previous, current, next)
}
\description{
Previous, current, and next positions of a given index in a cycle.
}
\details{
Given some position i in a n-length cycle, this function returns
the triple c(i-1,i,i+1) taking into account that the next
position of i=n is 1 and the previous position of i=1 is n.
It is used to perform a 4-exchange in a cycle.
}
\examples{
neigh_index(6, 9)  # 5 6 7
neigh_index(9, 9)  # 8 9 1
neigh_index(1, 9)  # 9 1 2

}
\author{
Cesar Asensio
}
