
#' Ordinal data from a radiological study of congenital diaphragmatic hernia.
#'
#' This data frame has exactly four columns. The first two columns contain liver herniation grades assigned by the first radiologist, and the final two columns contain grades assigned by the second radiologist. Each radiologist graded each image twice so that intra-rater consistency can be assessed. The liver grades and their meanings are provided below.
#'
#' \itemize{
#'   \item 1. No herniation of the liver into the fetal chest
#'   \item 2. Less than half of the ipsilateral thorax is occupied by the fetal liver
#'   \item 3. Greater than half of the thorax is occupied by the fetal liver
#'   \item 4. The liver dome reaches the thoracic apex
#'   \item 5. The liver dome not only reaches the thoracic apex but also extends across the thoracic midline
#' }
#'
#' @docType data
#' @keywords datasets
#' @name liver
#' @usage data(liver)
#' @format A data frame having 47 rows and four columns

NULL
