% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltcs.R
\name{ltcs}
\alias{ltcs}
\title{Analysis of Line x Tester data on single plant basis containing only Crosses laid out in RCBD or Alpha Lattice design.}
\usage{
ltcs(data, replication, line, tester, obs, y, block)
}
\arguments{
\item{data}{dataframe containing following variables}

\item{replication}{replication}

\item{line}{line}

\item{tester}{tester}

\item{obs}{single plant observations}

\item{y}{dependent variable}

\item{block}{block (for alpha lattice design only)}
}
\value{
\item{\code{Mean}}{Table of means.}\item{\code{ANOVA}}{ANOVA with all the factors.}\item{\code{GCA.Line}}{GCA effects of lines.}\item{\code{GCA.Tester}}{GCA effects of testers.}
\item{\code{SCA}}{SCA effects of crosses.}\item{\code{CV}}{Coefficent of Variation.}
\item{\code{Std.Error}}{Standard error for combining ability effects.}\item{\code{C.D.}}{Critical Difference at 5 pecent for combining ability effects.}
\item{\code{Contribution.of.Line.Tester}}{Contribution of Lines, Testers and Line x Tester towards total variation.}
}
\description{
Analysis of Line x Tester data on single plant basis containing only Crosses laid out in RCBD or Alpha Lattice design.
}
\details{
Analyzing the line by tester data single plant observations evaluated in RCBD and Alpha lattice design. All the factors are considered as fixed.
}
\note{
The block variable is inserted at the last if the experimental design is Alpha Lattice. For RCBD no need to have block factor.
}
\examples{
\dontrun{#Line Tester analysis data with only crosses in RCBD
library(gpbStat)
data(rcbdltcs)
result1 = ltcs(rcbdltcs, replication, line, tester, obs, yield)
result1

#Line Tester analysis data with only crosses in Alpha Lattice
library(gpbStat)
data(alphaltcs)
result2 = ltcs(alphaltcs, replication, line, tester, obs, yield, block)
result2
}
}
\references{
Kempthorne, O. (1957), Introduction to Genetic Statistics. John Wiley and Sons, New York.
             , 468-472.
Singh, R. K. and Chaudhary, B. D. (1977). Biometrical Methods in Quantitative Genetic Analysis. Kalyani Publishers, New Delhi.
Arunachalam, V. (1974), The fallacy behind use of modified line x tester design. The Indian Journal of Genetics and Plant Breeding, 34: 280-287.
}
\seealso{
\code{\link[gpbStat]{ltc}}, \link[gpbStat]{ltcmt}
}
\author{
Nandan L Patil \email{tryanother609@gmail.com}
}
