% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_nodes_attr.R
\name{add_nodes_attr}
\alias{add_nodes_attr}
\title{Add attributes to the nodes of a graph}
\usage{
add_nodes_attr(
  graph,
  input = "df",
  data,
  dir_path = NULL,
  layer = NULL,
  index = "Id",
  include = "all"
)
}
\arguments{
\item{graph}{A graph object of class \code{igraph}.}

\item{input}{A character string indicating the nature of the
input data from which come the attributes to add to the nodes.
\itemize{
\item{If 'input = "shp"', then attributes come from the attribute table of
a shapefile layer of type point.}
\item{If 'input = "df"', then attributes come from an object of class
\code{data.frame}}
}
In both cases, input attribute table or dataframe must have a column with
the exact same values as the node IDs.}

\item{data}{(only if 'input = "df"') The name of the object of
class \code{data.frame} with the attributes to add to the nodes.}

\item{dir_path}{(only if 'input = "shp"') The path (character string) to the
directory containing the shapefile layer of type point whose attribute
table contains the attributes to add to the nodes.}

\item{layer}{(only if 'input = "shp"') The name (character string) of the
shapefile layer of type point (without extension, ex.: "nodes" refers
to "nodes.shp" layer) whose attribute table contains the attributes
to add to the nodes.}

\item{index}{The name (character string) of the column with the nodes names
in the input data (column of the attribute table or of the dataframe).}

\item{include}{A character string (vector) indicating which columns of the
input data will be added as nodes' attributes.
By default, 'include = "all"', i.e. every column of the input data is added.
Alternatively, 'include' can be a vector with the names of the columns to add
(ex.: "c('x', 'y', 'pop_name')").}
}
\value{
A graph object of class \code{igraph}
}
\description{
The function adds attributes to the nodes of a graph from
either an object of class \code{data.frame} or from a shapefile layer.
The node IDs in the input objects must be the same as in the graph object.
}
\details{
The graph can be created with the function
\code{\link{graphab_to_igraph}} by importing output from Graphab projects.
Values of the metrics computed at the node level with Graphab can then be
added to such a graph with this function.
}
\examples{
data("data_tuto")
graph <- data_tuto[[3]]
df_nodes <- data.frame(Id = igraph::V(graph)$name,
                       Area = runif(50, min = 10, max = 60))
graph <- add_nodes_attr(graph,
                        data = df_nodes,
                        input = "df",
                        index = "Id",
                        include = "Area")
}
\author{
P. Savary
}
