% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_to_shp.R
\name{graph_to_shp}
\alias{graph_to_shp}
\title{Export a spatial graph to shapefile layers}
\usage{
graph_to_shp(
  graph,
  crds,
  mode = "both",
  crds_crs,
  layer,
  dir_path,
  metrics = FALSE
)
}
\arguments{
\item{graph}{A graph object of class \code{igraph}}

\item{crds}{(if 'mode = 'spatial'') A \code{data.frame} with the spatial
coordinates of the graph nodes. It must have three columns:
\itemize{
\item{ID: Name of the graph nodes (will be converted into character string).
The names must the same as the node names of the graph object of
class \code{igraph} (\code{igraph::V(graph)$name})}
\item{x: Longitude (numeric or integer) of the graph nodes in the coordinates
reference system indicated with the argument crds_crs.}
\item{y: Latitude (numeric or integer) of the graph nodes in the coordinates
reference system indicated with the argument crds_crs.}
}}

\item{mode}{Indicates which shapefile layers will be created
\itemize{
\item{If 'mode = 'both'' (default), then two shapefile layers are created,
one for the nodes and another for the links.}
\item{If 'mode = 'node'', a shapefile layer is created for the nodes only.}
\item{If 'mode = 'link'', a shapefile layer is created for the links only.}
}}

\item{crds_crs}{An integer indicating the EPSG code of the coordinates
reference system to use.
The projection and datum are given in the PROJ.4 format.}

\item{layer}{A character string indicating the suffix of the name of
the layers to be created.}

\item{dir_path}{A character string corresponding to the path to the directory
in which the shapefile layers will be exported. If \code{dir_path = "wd"},
then the layers are created in the current working directory.}

\item{metrics}{(not considered if 'mode = 'link'') Logical. Should graph
node attributes integrated in the attribute table of the node shapefile
layer? (default: FALSE)}
}
\value{
Create shapefile layers in the directory specified with the parameter
'dir_path'.
}
\description{
The function enables to export a spatial graph to
shapefile layers.
}
\examples{
\dontrun{
data(data_tuto)
mat_w <- data_tuto[[1]]
gp <- gen_graph_topo(mat_w = mat_w, topo = "gabriel")
crds_crs <- 2154
crds <- pts_pop_simul
layer <- "graph_dps_gab"
graph_to_shp(graph = gp, crds = pts_pop_simul, mode = "both",
             crds_crs = crds_crs,
             layer = "test_fonct",
             dir_path = tempdir(),
             metrics = FALSE)
 }
}
\author{
P. Savary
}
