% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remlOptimization_algorithms.R
\name{reml}
\alias{reml}
\alias{ai}
\alias{em}
\alias{gradFun}
\alias{tugug_trace}
\alias{gradFun_fd}
\title{REML optimization algorithms for mixed-effect models.}
\usage{
reml(
  nu,
  skel,
  thetaG,
  sLc,
  modMats,
  W,
  Bpinv,
  nminffx,
  nminfrfx,
  rfxlvls,
  rfxIncContrib2loglik,
  thetaR = NULL,
  tWW = NULL,
  RHS = NULL
)

em(
  nuvin,
  thetaG,
  thetaR,
  conv,
  rfxlvls,
  tugug,
  trace,
  y = NULL,
  r = NULL,
  nminffx = NULL
)

ai(nuvin, skel, thetaG, modMats, W, sLc, sln, r, thetaR = NULL, sigma2e = NULL)

tugug_trace(thetaG, nb, rfxlvls, listGeninv, Cinv, sln, pinv = NULL)

gradFun(
  nuvin,
  thetaG,
  rfxlvls,
  sln,
  tugug,
  trace,
  sigma2e = NULL,
  r = NULL,
  nminfrfx = NULL
)

gradFun_fd(nuvin, grObj, lL, fd = c("fdiff", "cdiff", "bdiff"))
}
\arguments{
\item{nu, nuvin}{A \code{list} or \code{vector} of (co)variance parameters to
estimate on the transformed, or nu, scale.}

\item{skel}{A skeleton for reconstructing the list of (co)variance parameters.}

\item{thetaG, thetaR}{\code{Integer} vectors indexing the G-structure or
R-structure of the (co)variance parameters.}

\item{sLc}{A sparse \code{Matrix} containing the symbolic Cholesky
factorization of the coefficient matrix of the Mixed Model Equations.}

\item{modMats}{A \code{list} of the model matrices used to construct the
mixed model equations.}

\item{W, tWW}{A sparse \code{Matrix} containing the design matrices for the fixed
and random effects (\code{W}) and the cross-product of this (\code{tWW}).}

\item{Bpinv}{A matrix inverse of the matrix containing the prior specification
for fixed effects.}

\item{nminffx, nminfrfx, rfxlvls}{\code{Integers} specifying: (1) the difference
between the number of observations and fixed effects (of the full rank fixed
effects design matrix (X), (2) \code{nminffx} minus the total number of
random effects, and (3) a \code{vector} of levels for each term in the 
random effects.}

\item{rfxIncContrib2loglik}{A \code{numeric} indicating the sum of constraint
contributions to the log-likelihood across all terms in the random effects
that have non-diagonal generalized inverse matrices (\code{ginverse}).
associated with a generalized inverse (\code{ginverse}).}

\item{RHS}{A sparse \code{Matrix} containing the Right-Hand Side to the 
Mixed Model Equations.}

\item{conv}{A \code{character} vector of (co)variance parameter constraints.}

\item{tugug}{A list of numeric values for the $u_g' u_g$ products of the
solution vector for each of the \code{g} variance parameters.}

\item{trace}{A list of traces of the inverse coefficient matrix for each of
of the \code{g} variance parameters.}

\item{y}{The response vector.}

\item{sln, r}{Sparse \code{Matrices} containing the solutions or residuals
of the Mixed Model Equations.}

\item{sigma2e}{A \code{numeric} value for the residual variance estimate
when it has been factored out of the Coefficient matrix of the Mixed Model
Equations, thus converting the (co)variance components to ratios
(represented by the variable lambda).}

\item{nb}{The number of columns in X.}

\item{listGeninv}{A list of generalized inverse matrices.}

\item{Cinv}{A sparse \code{Matrix} containing the inverse of the Coefficient
matrix to the Mixed Model Equations.}

\item{pinv}{An integer vector of the matrix permutation.}

\item{grObj}{An list of class \code{grMod}.}

\item{lL}{A numeric value for REML log-likelihood value.}

\item{fd}{A character indicating whether forward, combined, or backward finite
differences (\dQuote{fdiff}, \dQuote{cdiff}, or \dQuote{bdiff}, respectively)
are to be calculated.}
}
\value{
A \code{list} or \code{matrix} containing any of the previous
  parameters described above, or the following that are in addition to or
  instead of parameters above:
  \describe{
    \item{loglik }{The REML log-likelihood.}
    \item{tyPy,logDetC }{Components of the REML log-likelihood derived from the 
      Cholesky factor of the Coefficient matrix to the Mixed Model Equations.}
    \item{Cinv_ii }{A vector containing the diagonal elements of the inverse
      of the Coefficient matrix to the Mixed Model Equations (i.e., the
      diagonal entries of \code{Cinv}).}
    \item{AI }{A \code{matrix} of values containing the Average Information
      matrix, or second partial derivatives of the likelihood with respect to
      the transformed (co)variance components (nu). The inverse of this matrix
      gives the sampling variances of these transformed (co)variance components.}
    \item{dLdnu }{A single column \code{matrix} of first derivatives of
      the transformed (co)variance parameters (nu) with respect to the
      log-Likelihood.}
  }
}
\description{
Evaluate the REML likelihood and algorithms for iterating to find maximum 
  REML estimates.
}
\author{
\email{matthewwolak@gmail.com}
}
