% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include_tex.R
\name{include_tex}
\alias{include_tex}
\title{Include TeX file in R Markdown or Quarto document.}
\usage{
include_tex(path=".",chunk="",tex="",start=NA,end=NA)
}
\arguments{
\item{path}{Object or a character string representing the path(s) to the \code{TeX} (default: \code{"."})}

\item{chunk}{Name of the \code{gretl} chunk that generates the \code{TeX} file.}

\item{tex}{Name of a \code{LaTeX} file}

\item{start}{Numeric. The start line of the \code{TeX} file to include.}

\item{end}{Numeric. The last line of the \code{TeX} file to include.}
}
\value{
Set of \code{gretl} (open-source software for Econometrics) outputs
}
\description{
Use this function to include TeX file in R Markdown or Quarto document.
}
\examples{
library(gretlR)
\dontrun{
code=r'(nulldata 500
set seed 13
gretl1 = normal()
gretl2 = normal()
setobs 12 1980:01 --time-series
ols gretl1 const gretl2
tabprint --output="olsTable.tex")'

exec_gretl(code=code,path='gretlR/TeXFolder/gretlCode')

include_tex(chunk="TeXFolder",tex="olsTable")

# Alternatively, use the absolute/relative path to the TeX file

include_tex("gretlR/TeXFolder/olsTable.tex")
}
}
\seealso{
Other important functions: 
\code{\link{eng_gretl}()},
\code{\link{exec_gretl}()},
\code{\link{exec_inp}()},
\code{\link{gretlR}},
\code{\link{import_kable}()},
\code{\link{include_graph}()},
\code{\link{write_inp}()}
}
\concept{important functions}
\keyword{documentation}
