% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{prob_categories}
\alias{prob_categories}
\title{Probability for certain degree of saturation}
\usage{
prob_categories(r, m, min.prop = 1)
}
\arguments{
\item{r}{A dataframe. The result returned from \code{\link{sim_n_persons_x_times}}.}

\item{m}{minimal number of constructs in each category}

\item{min.prop}{Proportion of categores to contain at least m constructs.}
}
\description{
Calculate probability for getting certain proportion of categories with at
least m constructs
}
\examples{
r <- sim_n_persons_x_times(dexp(1:30, rate = .05), n = 50, a = 5:7, times = 100, progress = "none")
prob_categories(r, 4, min.prop = .9)

}
\seealso{
Other Utilities: \code{\link{calc_probabilities}},
  \code{\link{expected_frequencies}}
}

