% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_multi_rev_per_session.R
\name{sample_multi_rev_per_session}
\alias{sample_multi_rev_per_session}
\title{Sample Multiple Revenue Per Session}
\usage{
sample_multi_rev_per_session(input_df, priors, n_samples = 50000)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str),
sum_conversions (dbl), sum_sessions (dbl), sum_revenue (dbl),
sum_conversion_2 (dbl), sum_sessions_2 (dbl), sum_revenue_2 (dbl).}

\item{priors}{Optional list of priors alpha0 and beta0.
Default \eqn{Beta(1,1)} will be use otherwise.}

\item{n_samples}{Optional integer value. Defaults to 50,000 samples.}
}
\value{
input_df with 4 new nested columns `dirichlet_params`,
    `gamma_params_A`, `gamma_params_B`, and `samples`.
    `samples` in each row should be a tibble of length `n_samples`.
}
\description{
Adds 5 new nested columns to the input_df: `dirichlet_params`,
    `gamma_params_A`, `gamma_params_B`, and `samples`.
    This samples from multiple revenue per session distributions
    at once.
}
\details{
See update_rules vignette for a mathematical representation.

\deqn{conversion_i ~ MultiNomial(\phi_1, \phi_2, ..., \phi_k)}
\deqn{\phi_k ~ Dirichlet(\alpha, \beta)}
Conversion Rate is sampled from a Dirichlet distribution with a Multinomial likelihood
of an individual converting.
}
