% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stannard.R
\name{stannard}
\alias{stannard}
\alias{stannard.inverse}
\title{Stannard growth model}
\usage{
stannard(t, alpha, beta, k, m)

stannard.inverse(x, alpha, beta, k, m)
}
\arguments{
\item{t}{time}

\item{alpha}{upper asymptote}

\item{beta}{growth displacement}

\item{k}{growth rate}

\item{m}{slope of growth}

\item{x}{size}
}
\description{
Computes the Stannard growth model
\deqn{ y(t) = \alpha \left[ 1 + exp(-(\beta + k t)/m) \right]^{-m}}{ y(t) = \alpha *( 1 + exp(-(beta + k * t)/m))^(-m) }
}
\examples{
growth <- stannard(0:10, 1, .2, .1, .5)

# Calculate inverse function
time <- stannard.inverse(growth, 1, .2, .1, .5)

}
\references{
A. Khamiz, Z. Ismail, and A. T. Muhammad, "Nonlinear growth models for
modeling oil palm yield growth," Journal of Mathematics and Statistics,
vol. 1, no. 3, p. 225, 2005.
}
\author{
Daniel Rodriguez
}
