% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_power_surv.R
\name{op_power_surv}
\alias{op_power_surv}
\title{Provides operating characteristics of group sequential MAMS trial for survival outcome}
\usage{
op_power_surv(
  m0,
  alpha,
  beta,
  p,
  frac,
  hr0,
  hr1,
  nsim,
  ta,
  tf,
  kappa,
  eta,
  seed
)
}
\arguments{
\item{m0}{numeric Median survival time of control group.}

\item{alpha}{numeric Type I error.}

\item{beta}{numeric Type II error.}

\item{p}{numeric Number of treatment arms.}

\item{frac}{numeric Vector of fractions for information time at each look.}

\item{hr0}{numeric Hazard ratio of ineffective treatment group vs control.}

\item{hr1}{numeric Hazard ratio of effective treatment group vs control.}

\item{nsim}{numeric Number of simulations.}

\item{ta}{numeric Accrual time.}

\item{tf}{numeric Follow-up time.}

\item{kappa}{numeric Shape parameter (kappa=1 for exponential distribution).}

\item{eta}{numeric  Rate of loss to follow-up.}

\item{seed}{numeric Random seed number.}
}
\value{
A list of power, stage-wise probability of success, stopping probability, probability of futility, average number of events happened per arm, average duration of trial.
}
\description{
Computes power and other characteristics for group-sequential MAMS trial for survival outcome.
}
\examples{
op_power_surv(m0 = 20,
              alpha = 0.05,
              beta = 0.1,
              p = 4,
              frac = c(1 / 2, 1),
              hr0 = 1,
              hr1 = 0.74,
              ta = 12,
              tf = 40,
              nsim = 20,
              kappa = 1,
              eta = 0,
              seed = 12)
}
