\name{gsalib-package}
\alias{gsalib-package}
\alias{gsalib}
\docType{package}
\title{
Utility functions for GATK
}
\description{
Utility functions for analysis of genome sequence data with the GATK
}
\details{
\tabular{ll}{
Package: \tab gsalib\cr
Type: \tab Package\cr
Version: \tab 2.2\cr
Date: \tab 2015-03-17\cr
License: \tab MIT\cr
LazyLoad: \tab yes\cr
}
This package is primarily meant to be used programmatically by GATK tools. However the gsa.read.gatkreport() function can be used to easily read in data from a GATKReport. A GATKReport is a multi-table document generated by GATK tools. 
}
\author{
Kiran Garimella

Maintainer: Louis Bergelson <louisb@broadinstitute.org>
}
\references{
https://gatk.broadinstitute.org/hc/en-us/articles/360035532172-GATKReport-and-gsalib
}
\keyword{ package }
\examples{
test_file = system.file("inst", "extdata", "test_gatkreport.table", package = "gsalib");
report = gsa.read.gatkreport(test_file);
}
