% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsaot_indices.R
\name{confint.gsaot_indices}
\alias{confint.gsaot_indices}
\title{Compute confidence intervals for sensitivity indices}
\usage{
\method{confint}{gsaot_indices}(object, parm = NULL, level = 0.95, type = "norm", ...)
}
\arguments{
\item{object}{An object of class \code{gsaot_indices}, with bootstrap results
included.}

\item{parm}{A specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing, all
parameters are considered.}

\item{level}{(default is 0.95) Confidence level for the interval.}

\item{type}{(default is \code{"norm"}) Method to compute the confidence interval.
For more information, check the \code{type} option of \code{\link[boot:boot.ci]{boot::boot.ci()}}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{input}: Name of the input variable.
\item \code{component}: The index component for Wasserstein-Bures.
\item \code{index}: Estimated indices
\item \code{original}: Original estimates.
\item \code{bias}: Bootstrap bias estimate.
\item \code{low.ci}: Lower bound of the confidence interval.
\item \code{high.ci}: Upper bound of the confidence interval.
}
}
\description{
Computes confidence intervals for a \code{gsaot_indices} object using
bootstrap results.
}
\examples{
N <- 1000

mx <- c(1, 1, 1)
Sigmax <- matrix(data = c(1, 0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.5, 1), nrow = 3)

x1 <- rnorm(N)
x2 <- rnorm(N)
x3 <- rnorm(N)

x <- cbind(x1, x2, x3)
x <- mx + x \%*\% chol(Sigmax)

A <- matrix(data = c(4, -2, 1, 2, 5, -1), nrow = 2, byrow = TRUE)
y <- t(A \%*\% t(x))

x <- data.frame(x)
y <- y

res <- ot_indices_wb(x, y, 10, boot = TRUE, R = 100)
confint(res, parm = c(1,3), level = 0.9)

}
