% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_pedigree_for_inbreeding.R
\name{check_pedigree_for_inbreeding}
\alias{check_pedigree_for_inbreeding}
\title{Check the a GSP (in prepped list format) for inbreeding loops}
\usage{
check_pedigree_for_inbreeding(GP)
}
\arguments{
\item{GP}{A gsp in list format as produced by the function
\code{prep_gsp_for_hap_dropping()}.  See the documentation for the return
object of \code{prep_gsp_for_hap_dropping()} for a description.}
}
\value{
This function does not return anything.  It throws an error via \code{stop()} if
inbreeeding loops are found in the pedigree.  Before throwing that error it lists
the individuals with repeated occurrences in their ancestry vectors via the
\code{message()} function.
}
\description{
After a GSP has been passed through \code{prep_gsp_for_hap_dropping()} it
is in a list format with the individuals ordered in such a way that
it should be easy to check for any inbreeding loops in it (which
are not allowed!).  This version uses a simple recursive
approach to compute the ancestry vector for each individual, and it
detects inbreeding by the occurrence of the same ID in the ancestry
vector more than once.  This might be slow on large pedigrees, but for
most that people would use, this should be fine.
}
\details{
Note that the ancestry vector produced by this is not ordered the
way the ancestry vectors are in my package CKMRpop---for simplicity
I just get a list of ancestors in whatever order they happen to be
reached.
}
\examples{
# get the 13 member pedigree in the data object GSP and
# turn it into a list
GP <- prep_gsp_for_hap_dropping(GSP)

# check it for inbreeding. (There is none)
check_pedigree_for_inbreeding(GP)

## This one will fail, so we wrap it in tryCatch so CRAN
## check doesn't find it a problem.
# To see what happens if there are inbreeding loops, make some
GP_inbred <-  GP
# make 12 be inbred trough individual 6
GP_inbred$`12`$par1$par = "13"
# make 8 inbred (because both of its founder parents are the same!)
GP_inbred$`8`$par2$par = "4"

# now try that:
tryCatch(
  check_pedigree_for_inbreeding(GP_inbred),
  error = function(x) 0,
  warning = function(x) 0
)
}
